onEvent("block.registry", event => {
    event.create("winter_wheat", "crop")
        .age(7, builder => {
            builder
                .shape(0, 0, 0, 0, 16, 3, 16)
                .shape(1, 0, 0, 0, 16, 5, 16)
                .shape(2, 0, 0, 0, 16, 7, 16)
                .shape(3, 0, 0, 0, 16, 8, 16)
                .shape(4, 0, 0, 0, 16, 12, 16)
                .shape(5, 0, 0, 0, 16, 14, 16)
                .shape(6, 0, 0, 0, 16, 15, 16)
                .shape(7, 0, 0, 0, 16, 16, 16)
        })
        .survive((state, level, pos) => {
            const FARMLAND = java('net.minecraft.world.level.block.FarmBlock')
            let blockState = level.getBlockState(pos.below())
            let mcBlock = blockState.block
            if (mcBlock instanceof FARMLAND) {
                return true
            }
            else return false
        })
        .growTick((tickevent) => 10)
        .bonemeal(info => 1)
        .dropSeed(true)
        .crop("minecraft:wheat", 1.0)
        .texture(0, "minecraft:block/wheat_stage0")
        .texture(1, "minecraft:block/wheat_stage1")
        .texture(2, "minecraft:block/wheat_stage2")
        .texture(3, "minecraft:block/wheat_stage3")
        .texture(4, "minecraft:block/wheat_stage4")
        .texture(5, "minecraft:block/wheat_stage5")
        .texture(6, "minecraft:block/wheat_stage6")
        .texture(7, "minecraft:block/wheat_stage7")
        .item((seedItem) => {
            seedItem.texture("kubejs:item/winter_wheat_seed")
        })
})